/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.utils;

import java.util.Collection;
import java.util.LinkedList;

public class BoundedList<T>
extends LinkedList<T> {
    private final int maxSize;

    public BoundedList(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean add(T element) {
        while (this.size() > this.maxSize) {
            super.removeFirst();
        }
        return super.add(element);
    }

    @Override
    public void add(int index, T element) {
        while (this.size() > this.maxSize) {
            super.removeFirst();
        }
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        while (this.size() > this.maxSize) {
            super.removeFirst();
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        while (this.size() > this.maxSize) {
            super.removeFirst();
        }
        return super.addAll(index, c);
    }
}

